* Title: 	figure1.do
* Version: 	23 May 2018
* Purpose: 	Produce graph of migration rates


*******************************************************************************
* (0) Start of file
*******************************************************************************

capture log close
log using output/figures/log/figure1, text replace
set more off
clear all
macro drop _all


*******************************************************************************
* (1) Load data
*******************************************************************************

use dta/census_migration_clean, clear


*******************************************************************************
* (2) Construct three-year pooled migration rates
*******************************************************************************

tsset Year
foreach var of varlist Intracounty Intercounty {
	gen `var'_RateAvg = 100 * (L.`var' + `var' + F.`var')/(L.Total + Total + F.Total)
	replace `var'_RateAvg = 100 * `var'/Total if (Year == 1971 | Year == 1976 | Year == 1981)
}

keep if Year>=1949 & Year<=2016
keep Year Intracounty_RateAvg Intercounty_RateAvg

* Save dataset
compress
save output/figures/dta/figure1.dta, replace


*******************************************************************************
* (3) Produce graph
*******************************************************************************

line 	Intracounty_RateAvg Intercounty_RateAvg Year, ///
		legend(label(1 "Intracounty Migration") label(2 "Intercounty Migration")) ///
		graphregion(color(white)) bgcolor(white) ///
		xtitle("Year") ytitle("Migration rate, percent")
		
graph save output/figures/gph/figure1, replace
graph export output/figures/eps/figure1.eps, as(eps) replace
export excel using output/figures/xlsx/figure1.xlsx, first(variables) replace


*******************************************************************************
* (4) End of file
*******************************************************************************

log close
exit, clear
